#include "dircreator.h"



#include <QFileInfo>
#include <QDir>


#include <QProcess>

#ifdef Q_OS_WIN32
extern Q_CORE_EXPORT int qt_ntfs_permission_lookup;

#include "aclapi.h"
#include "sddl.h"
#include <io.h>
#include <sys/stat.h>

static void allowEveryone(const QString &path)
{
//	qWarning() << path;
    PACL pDacl,pNewDACL;
    EXPLICIT_ACCESS ExplicitAccess;
    PSECURITY_DESCRIPTOR ppSecurityDescriptor;
    PSID psid;


    LPTSTR lpStr = new wchar_t[path.size() + 1];

    path.toWCharArray(lpStr);

    DWORD res = GetNamedSecurityInfo(lpStr, SE_FILE_OBJECT,DACL_SECURITY_INFORMATION, NULL, NULL, &pDacl, NULL, &ppSecurityDescriptor);
    BOOL bres = ConvertStringSidToSid(L"S-1-1-0", &psid);
//	qWarning() << "GetNamedSecurityInfo" << res << ERROR_SUCCESS << bres;


    ExplicitAccess.grfAccessMode = SET_ACCESS;
    ExplicitAccess.grfAccessPermissions = GENERIC_ALL;
    ExplicitAccess.grfInheritance = CONTAINER_INHERIT_ACE | OBJECT_INHERIT_ACE;
    ExplicitAccess.Trustee.MultipleTrusteeOperation = NO_MULTIPLE_TRUSTEE;
    ExplicitAccess.Trustee.pMultipleTrustee = NULL;
    ExplicitAccess.Trustee.ptstrName = (LPTSTR) psid;
    ExplicitAccess.Trustee.TrusteeForm = TRUSTEE_IS_SID;
    ExplicitAccess.Trustee.TrusteeType = TRUSTEE_IS_UNKNOWN;

    res = SetEntriesInAcl(1, &ExplicitAccess, pDacl, &pNewDACL);
//	qWarning() << "SetEntriesInAcl"<< res << ERROR_SUCCESS;

    res = SetNamedSecurityInfo(lpStr,SE_FILE_OBJECT,DACL_SECURITY_INFORMATION,NULL,NULL,pNewDACL,NULL);
//	qWarning() << "SetNamedSecurityInfo"<< res << ERROR_SUCCESS;

    LocalFree(pNewDACL);
    LocalFree(psid);
    delete [] lpStr;
}

#else
    static int qt_ntfs_permission_lookup;
#endif


const QFile::Permissions DirCreator::DEFAULT_OWNER =
        QFileDevice::ReadOwner | QFileDevice::WriteOwner | QFileDevice::ExeOwner |
        QFileDevice::ReadUser | QFileDevice::WriteUser | QFileDevice::ExeUser;
const QFile::Permissions DirCreator::DEFAULT_GROUP = DirCreator::DEFAULT_OWNER |
        QFileDevice::ReadGroup | QFileDevice::WriteGroup | QFileDevice::ExeGroup;
const QFile::Permissions DirCreator::DEFAULT_ALL = DirCreator::DEFAULT_GROUP |
        QFileDevice::ReadOther | QFileDevice::WriteOther | QFileDevice::ExeOther;

const QFile::Permissions DirCreator::FILE_DEFAULT_OWNER =
        QFileDevice::ReadOwner | QFileDevice::WriteOwner;
const QFile::Permissions DirCreator::FILE_DEFAULT_GROUP = DirCreator::FILE_DEFAULT_OWNER |
        QFileDevice::ReadGroup | QFileDevice::WriteGroup;
const QFile::Permissions DirCreator::FILE_DEFAULT_ALL = DirCreator::FILE_DEFAULT_GROUP |
        QFileDevice::ReadOther | QFileDevice::WriteOther;


bool DirCreator::checkAndCreate(const QString &path, const QFile::Permissions &permissions)
{

    QFileInfo fi (path);
    if(!fi.exists())
    {
        QDir dir(fi.absoluteFilePath());
        QDir rd(dir.root());
        bool res = rd.mkpath(fi.absoluteFilePath());
        qt_ntfs_permission_lookup++; // turn checking on
        QFile::setPermissions(fi.absoluteFilePath(), permissions);
        qt_ntfs_permission_lookup--; // turn it off again
    }
    fi = QFileInfo(path);
    return fi.exists();
}

bool DirCreator::changeFilePermissions(const QString &fileName, const QFileDevice::Permissions &permissions)
{
    qt_ntfs_permission_lookup++; // turn checking on
    bool res = changeFilePermissionsP(fileName, permissions);
    qt_ntfs_permission_lookup--; // turn it off again
    return res;
}

bool DirCreator::changeDirPermissions(const QString &path, bool recursive, const QFileDevice::Permissions &permissions)
{
    qt_ntfs_permission_lookup++;
    bool res = changeDirPermissionsP(path, recursive, permissions);
    qt_ntfs_permission_lookup--; // turn it off again
    return res;
}

bool DirCreator::changeDirPermissionsP(const QString &path, bool recursive, const QFileDevice::Permissions &permissions)
{
    QFileInfo fi (QDir::fromNativeSeparators(path));
    if(fi.exists())
    {
        QFile::setPermissions(fi.absoluteFilePath(), permissions);
#ifdef Q_OS_WIN32
        allowEveryone(path);
#endif
        if(recursive && fi.isDir())
        {
            QDir dir(fi.absoluteFilePath());
            QFileInfoList fil = dir.entryInfoList(QStringList(), QDir::NoDotAndDotDot | QDir::Files | QDir::Dirs);
//			qWarning() << fi.absoluteFilePath() << dir.absolutePath() << fil.size();
            for(const QFileInfo &fi :fil)
            {
                if(fi.isDir()) changeDirPermissionsP(fi.absoluteFilePath(), recursive, permissions);
                else if(fi.isFile()) changeFilePermissionsP(fi.absoluteFilePath(), permissions);
            }
        }
    }
    return fi.exists();
}

bool DirCreator::changeFilePermissionsP(const QString &fileName, const QFileDevice::Permissions &permissions)
{
    QFileInfo fi (QDir::fromNativeSeparators(fileName));
    if(fi.exists())
    {
        QFile::setPermissions(fi.absoluteFilePath(), permissions);
#ifdef Q_OS_WIN32
        allowEveryone(fileName);
#endif

    }
    return fi.exists();

}


