#ifndef DIRCREATOR_H
#define DIRCREATOR_H

#include <QFile>

class QString;

class DirCreator
{
    Q_DISABLE_COPY(DirCreator)
    DirCreator() = default;
    ~DirCreator()= default;
public:
    static const QFile::Permissions DEFAULT_OWNER;
    static const QFile::Permissions DEFAULT_GROUP;
    static const QFile::Permissions DEFAULT_ALL;
    static const QFile::Permissions FILE_DEFAULT_OWNER;
    static const QFile::Permissions FILE_DEFAULT_GROUP;
    static const QFile::Permissions FILE_DEFAULT_ALL;
    static bool checkAndCreate(const QString &path, const QFile::Permissions &permissions = DEFAULT_ALL);
    static bool changeFilePermissions(const QString &fileName, const QFile::Permissions &permissions = FILE_DEFAULT_ALL);
    static bool changeDirPermissions(const QString &path, bool recursive, const QFile::Permissions &permissions = DEFAULT_ALL);
private:
    static bool changeDirPermissionsP(const QString &path, bool recursive, const QFile::Permissions &permissions = DEFAULT_ALL);
    static bool changeFilePermissionsP(const QString &fileName, const QFile::Permissions &permissions = FILE_DEFAULT_ALL);

};


#endif // DIRCREATOR_H
