#ifndef FIRMWAREMANIPULATOR_H
#define FIRMWAREMANIPULATOR_H


#include <QVector>
#include <tuple>
#include <QByteArray>
#include <QIODevice>

class FirmwareManipulator
{
    Q_DISABLE_COPY(FirmwareManipulator)

public:
    static const quint64 E = 0x10001;
    static const quint64 D = 0xcb2c1;
    static const quint64 N = 0xf98a5;
    FirmwareManipulator();
    ~FirmwareManipulator();

    QByteArray encrypt(QByteArray &message, quint64 e, quint64 n);
    QByteArray decrypt(const QByteArray &message, quint64 d, quint64 n);

    bool encryptFile(const QString &srcFile, const QString &destFile, quint32 versionCode, const QString &version, quint64 e, quint64 n);
    bool encryptFile(const QString &srcFile, QIODevice *dest, quint32 versionCode, const QString &version, quint64 e, quint64 n);
    bool decryptFile(const QString &srcFile, const QString &destFile,  quint64 d, quint64 n, quint32 & versionCode, QString &version);
    bool decryptFile(QIODevice *src, const QString &destFile,  quint64 d, quint64 n, quint32 & versionCode, QString &version);


    void generateRsaKeys(quint64 p, quint64 q, quint64 &e, quint64 &d, quint64 &n);
    size_t numBytes(quint64 n);

private:
    quint64 modExp(quint64 base, quint64 exp, quint64 mod);
    std::tuple<qint64, qint64, qint64> extendedGcd(qint64 a, qint64 b);
    // quint64 gcd(quint64 a, quint64 b);
    QByteArray numToBytes(quint64 num, size_t len);
    quint64 bytesToNum(const uint8_t* bytes, size_t len);

    QByteArray encryptAligned(const QByteArray &message, quint64 e, quint64 n);
    QByteArray decryptAligned(const QByteArray &message, quint64 d, quint64 n);
};

#endif // FIRMWAREMANIPULATOR_H
