#ifndef FIXNUMBER_H
#define FIXNUMBER_H

#include <QtGlobal>
#include <QString>
#include <QMetaType>
#include <QVariant>


class FixNumber
{
protected:
    static const quint32 DEFAULT_MULTIPLIER = 100;
public:
    FixNumber() noexcept;
    explicit FixNumber(quint32 realMultiplier)noexcept;
    explicit FixNumber(const QVariantMap &map);
    FixNumber(quint32 realMultiplier, qint64 value)noexcept;
    FixNumber(quint32 realMultiplier, double value)noexcept;
    FixNumber(quint32 realMultiplier, const QString &value)noexcept;
    FixNumber(const FixNumber &other)noexcept;
    FixNumber(FixNumber &&other)noexcept;
    virtual ~FixNumber();

    quint32 realMultiplier() const;
    void setRealMultiplier(const quint32 &realMultiplier);

    qint64 value() const;
    void setValue(const qint64 &value);

    virtual double toDouble() const;
    virtual QString toString() const;
    virtual QString toString(const QChar &dp, const QChar &intDelim = QChar()) const;
    virtual QString toShortString(const QChar &dp = QLatin1Char(',')) const;
    virtual FixNumber round(quint32 realMultiplier) const;
    virtual void setDouble(double val);
    virtual void setString(const QString &val);
    virtual bool setAllFromString(const QString &val);

    virtual qint32 decimals() const;
    virtual void setDecimal(qint32 d);

    QVariantMap toMap() const;
    void setMap(const QVariantMap &map);


    FixNumber &operator=(const FixNumber &other)noexcept;
    FixNumber &operator=(FixNumber &&other)noexcept;
    bool operator==(const FixNumber &other) const noexcept;
    bool operator!=(const FixNumber &other) const noexcept;
    bool operator>(const FixNumber &other) const noexcept;
    bool operator>=(const FixNumber &other) const noexcept;
    bool operator<(const FixNumber &other) const noexcept;
    bool operator<=(const FixNumber &other) const noexcept;

    FixNumber operator+(const FixNumber &other) const noexcept;
    FixNumber operator-(const FixNumber &other) const noexcept;
    FixNumber &operator+=(const FixNumber &other) noexcept;
    FixNumber &operator-=(const FixNumber &other) noexcept;
protected:
    quint32 realMultiplier_;
    qint64 value_;
};


Q_DECLARE_METATYPE(FixNumber)

#endif // FIXNUMBER_H
