#ifndef FORMATUTILS_H
#define FORMATUTILS_H

#include "fixnumber.h"
#include "coreapiconst.h"

#include <QDateTime>
#include <QString>
#include <QVariantMap>


class FormatUtils
{
public:
    static QString dtToFullIsoStr(const QDateTime &dt);
    static QDateTime strToDt(const QString &dt);
    static FixNumber parseSumm(const QString &name, const QVariantMap &map, quint32 decPoint, CoreApiConst::ErrorCode *error = nullptr);
    static FixNumber parseSumm(const QString &sum, quint32 decPoint, CoreApiConst::ErrorCode *error = nullptr);

    //Объединяет пл ключам. если ключ есть в first - ключ из second не берется. если значения разные - теряются. Применять только при сериализации
    static QVariantMap unitMaps(const QVariantMap &first, const QVariantMap &second);

    static bool checkStringForFs(const QString &value);
    static QString formatStringForFs(const QString &value);
    static FixNumber uint48ToFixNumber(const QByteArray &data, quint32 mult, bool *ok = nullptr);
    static QByteArray fixNumberToUint48(const FixNumber &val, bool *ok = nullptr);
    static FixNumber uint40ToFixNumber(const QByteArray &data, quint32 mult, bool *ok = nullptr);
    static QByteArray fixNumberToUint40(const FixNumber &val, bool *ok = nullptr);
    static quint32 fsToUint32(const QByteArray &data, bool *ok = nullptr);
    static QByteArray uint32ToFs(quint32 val);
    static quint32 fsToUint16(const QByteArray &data, bool *ok = nullptr);
    static QByteArray uint16ToFs(quint16 val);

    static bool checkString(const QString &val, qint32 maxLen, bool fixedLen,
                            bool canBeEmpty, QString &suffixMsg);
    static bool checkEmail(const QString &val, qint32 maxLen,
                           bool canBeEmpty, QString &suffixMsg);
    static bool checkPhone(const QString &val, qint32 maxLen,
                           bool canBeEmpty, QString &suffixMsg);


    static QString rawLabelToTransport(const QString &text);
    static QString rawLabelFromTransport(const QString &text);

private:
    FormatUtils();
    ~FormatUtils();
};

#define DT2STR_(X) FormatUtils::dtToFullIsoStr(X)
#define STR2DT_(X) FormatUtils::strToDt(X)
#define STR4FS_(X) FormatUtils::formatStringForFs(X)

#define UNIT_MAPS(X,Y) FormatUtils::unitMaps(X, Y)
#define TOUINTOK48_(X,Y) FormatUtils::fixNumberToUint48(X, Y)
#define TOUINT48_(X) FormatUtils::fixNumberToUint48(X)
#define FROMUINTOK48_(X,Y,Z) FormatUtils::uint48ToFixNumber(X, Y, Z)
#define FROMUINT48_(X,Y) FormatUtils::uint48ToFixNumber(X, Y)

#endif // FORMATUTILS_H
