#ifndef LABELCODE_H
#define LABELCODE_H

#include "fixnumber.h"
#include "receiptdataclasses.h"

#include <QString>


class LabelCode
{
    friend class ProductCodeCreator;
public:
    LabelCode();
    LabelCode(const LabelCode &other);
    LabelCode(LabelCode &&other);
    ~LabelCode();

    bool readyToB() const;


    QByteArray preparedLabel()const;
    QString tradeMark() const;

    ProductCode productCode() const;

    ProductCode::Type type() const;
    QString typeName() const;

    const QString &t91() const;

    const QString &t92() const;
    const QString &t93() const;

    quint8 idx91() const;
    quint8 idx92() const;

    QString calc2115() const;

    fdf::LabelCodeType lct2100() const;

    bool isValid() const;
    bool isEncodedTradeMark() const;
    bool isGs() const;
    bool isRecognizedCode() const;

    QStringList searchCodes() const;

    FixNumber getMaxPrice(bool *ok = nullptr) const;

    void clear();
    quint32 tailCrc() const;

    QVariantMap toMap() const;
    QVariantMap toExternalMap() const;
    void parseMap(const QVariantMap &map);


    LabelCode &operator =(const LabelCode &other);
    LabelCode &operator =(LabelCode &&other);
    bool operator ==(const LabelCode &other) const;
    bool operator !=(const LabelCode &other) const;


private:
    QString tradeMark_;
    ProductCode code_;
    QString t91_;
    QString t92_;
    QString t93_;

    LabelCode(const QString &tm, const ProductCode &pc);
    LabelCode(const QString &tm, const ProductCode::Type &t, const QString &code);
    void setTradeMark(const QString &tradeMark);
    void setProductCode(const ProductCode &productCode);

    FixNumber decodeMaxPrice(const QByteArray &str) const;

    qint64 intCode() const;
    void setT91(const QString &newT91);
    void setT92(const QString &newT92);
    void setT93(const QString &newT93);
};


//--------------------------------------------------------------------------------------------------



#endif//LABELCODE_H
