#ifndef PRODUCTCODECREATOR_H
#define PRODUCTCODECREATOR_H

#include "labelcode.h"

#include <QObject>




class ProductCodeCreator : public QObject
{
    Q_OBJECT
    Q_DISABLE_COPY(ProductCodeCreator)
    friend class LabelCode;
public:

    explicit ProductCodeCreator(QObject *parent = nullptr);
    virtual ~ProductCodeCreator() override;

    LabelCode create(const QString &barCode) const;
    static QString printableText(const QByteArray &data);

    static QString checkAndPrepareGs1(const QString &code);
    static QString checkAndPrepareKis(const QString &code);

signals:
private:
    bool checkEan8(const QString &barCode, LabelCode &res) const;
    bool checkEan13(const QString &barCode, LabelCode &res) const;
    bool checkItf14(const QString &barCode, LabelCode &res) const;
    bool checkGs1(const QString &barCode, LabelCode &res) const;
    bool checkShortCode(const QString &barCode, LabelCode &res) const;
    bool checkFur(const QString &barCode, LabelCode &res) const;
    bool checkEgais2(const QString &barCode, LabelCode &res) const;
    bool checkEgais3(const QString &barCode, LabelCode &res) const;

    static bool checkBarckodeCrc(const QString &str);
};


#endif // PRODUCTCODECREATOR_H
