#include "qextdes.h"
#include "des.h"


QExtDes::QExtDes() :
    ks_(nullptr)
{

}

QExtDes::QExtDes(const QByteArray &key) :
    ks_(nullptr)
{
    genSubKeys(key);
}

QExtDes::~QExtDes()
{
    if(ks_)
    {
        delete[] reinterpret_cast<key_set*>(ks_);
    }
}

void QExtDes::genSubKeys(const QByteArray &key)
{
    if(ks_)
    {
        delete[] reinterpret_cast<key_set*>(ks_);
        ks_ = nullptr;
    }
    if(!key.isEmpty())
    {
        ks_ = new key_set[17];
        ::memset(ks_, 0, sizeof (key_set) * 17);
        unsigned char *k = new unsigned char[static_cast<size_t>(key.size())];
        memcpy(k, key.constData(), static_cast<size_t>(key.size()));
        generate_sub_keys(k, reinterpret_cast<key_set*>(ks_));
        delete [] k;
    }
}

void QExtDes::processMessage(const QByteArray &source, QByteArray &target, Mode mode)
{
    if(!ks_)
    {
        target = source;
    }
    {
        unsigned char *s = new unsigned char[static_cast<size_t>(source.size())],
                *t = new unsigned char[static_cast<size_t>(source.size())];
        memcpy(s, source.constData(), static_cast<size_t>(source.size()));
        memset(t, 0, static_cast<size_t>(source.size()));
        process_message(s, t, reinterpret_cast<key_set*>(ks_), static_cast<qint32>(mode));
        target = QByteArray(reinterpret_cast<char*>(t), source.size());
        delete [] s;
        delete [] t;
    }
}

void QExtDes::processMessage(const QByteArray &key, const QByteArray &source, QByteArray &target, Mode mode)
{
    if(key.isEmpty()) target = source;
    else
    {
        genSubKeys(key);
        processMessage(source, target, mode);
    }
}
//------------------------------------------------------------------------------------------------------

QExt3Des::QExt3Des() :
    d1(),
    d2(),
    d3()
{

}

QExt3Des::QExt3Des(const QByteArray &key1, const QByteArray &key2, const QByteArray &key3) :
    d1(key1),
    d2(key2),
    d3(key3)
{

}

QExt3Des::~QExt3Des()
{

}

void QExt3Des::genSubKeys(const QByteArray &key1, const QByteArray &key2, const QByteArray &key3)
{
    d1.genSubKeys(key1);
    d2.genSubKeys(key2);
    d3.genSubKeys(key3);
}

void QExt3Des::processMessage(const QByteArray &source, QByteArray &target, QExtDes::Mode mode)
{
    if(mode == QExtDes::Mode::Encrypt)
    {
        QByteArray buf1, buf2;
        d1.processMessage(source, buf1, QExtDes::Mode::Encrypt);
        d2.processMessage(buf1, buf2, QExtDes::Mode::Decrypt);
        d3.processMessage(buf2, target, QExtDes::Mode::Encrypt);
    }
    else
    {
        QByteArray buf1, buf2;
        d3.processMessage(source, buf1, QExtDes::Mode::Decrypt);
        d2.processMessage(buf1, buf2, QExtDes::Mode::Encrypt);
        d1.processMessage(buf2, target, QExtDes::Mode::Decrypt);
    }
}

void QExt3Des::processMessageEEE(const QByteArray &source, QByteArray &target, QExtDes::Mode mode)
{
    if(mode == QExtDes::Mode::Encrypt)
    {
        QByteArray buf1, buf2;
        d1.processMessage(source, buf1, QExtDes::Mode::Encrypt);
        d2.processMessage(buf1, buf2, QExtDes::Mode::Encrypt);
        d3.processMessage(buf2, target, QExtDes::Mode::Encrypt);
    }
    else
    {
        QByteArray buf1, buf2;
        d3.processMessage(source, buf1, QExtDes::Mode::Decrypt);
        d2.processMessage(buf1, buf2, QExtDes::Mode::Decrypt);
        d1.processMessage(buf2, target, QExtDes::Mode::Decrypt);
    }
}

void QExt3Des::processECB(const QByteArray &source, QByteArray &target, QExtDes::Mode mode)
{
    target.clear();
    for(int i = 0; i < source.size(); i += 8)
    {
        QByteArray src = source.mid(i, 8), tg;
        if(src.size() < 8) src = src + QByteArray(8 - src.size(), static_cast<char>(8 - src.size()));
        processMessage(src, tg, mode);
        target.append(tg);
    }
}

void QExt3Des::processECBEE(const QByteArray &source, QByteArray &target, QExtDes::Mode mode)
{
    target.clear();
    for(int i = 0; i < source.size(); i += 8)
    {
        QByteArray src = source.mid(i, 8), tg;
        if(src.size() < 8) src = src + QByteArray(8 - src.size(), static_cast<char>(8 - src.size()));
        processMessageEEE(src, tg, mode);
        target.append(tg);
    }
}



