#ifndef QEXTDES_H
#define QEXTDES_H

#include <QByteArray>


class QExtDes
{
    Q_DISABLE_COPY(QExtDes)
public:
    enum class Mode
    {
        Decrypt			= 0x00,
        Encrypt			= 0x01
    };
    QExtDes();
    explicit QExtDes(const QByteArray &key);
    ~QExtDes();

    void genSubKeys(const QByteArray &key);
    void processMessage(const QByteArray &source,  QByteArray &target, Mode mode);
    void processMessage(const QByteArray &key, const QByteArray &source,  QByteArray &target, Mode mode);

private:
    void *ks_;
};


//------------------------------------------------------------------------------------------------------

class QExt3Des
{
    Q_DISABLE_COPY(QExt3Des)
public:
    QExt3Des();
    QExt3Des(const QByteArray &key1, const QByteArray &key2, const QByteArray &key3);
    ~QExt3Des();

    void genSubKeys(const QByteArray &key1, const QByteArray &key2, const QByteArray &key3);
    void processMessage(const QByteArray &source,  QByteArray &target, QExtDes::Mode mode);
    void processMessageEEE(const QByteArray &source,  QByteArray &target, QExtDes::Mode mode);
    void processECB(const QByteArray &source,  QByteArray &target, QExtDes::Mode mode);
    void processECBEE(const QByteArray &source,  QByteArray &target, QExtDes::Mode mode);
private:
    QExtDes d1, d2, d3;
};


#endif // QEXTDES_H
