#include "syncsocketwrapper.h"


#include <QHostAddress>
#include<QHostInfo>
#include <QAuthenticator>

//Q_DECLARE_LOGGING_CATEGORY(log_)
//Q_LOGGING_CATEGORY(SOCKET, "sock")

SyncSocketWrapper::SyncSocketWrapper(QObject *parent)
    : QObject(parent)
{

}

SyncSocketWrapper::~SyncSocketWrapper()
{
    if(socket_)
    {
        socket_->disconnectFromHost();
    }
    if(loopTimer_)
    {
        loopTimer_->stop();
    }
}

bool SyncSocketWrapper::connectedToHost() const
{
    return socket_ && socket_->state() == QTcpSocket::ConnectedState;
}

bool SyncSocketWrapper::connectToHost(const QString &host, quint16 port)
{
    QList<QHostAddress> addrss = QHostInfo::fromName(host).addresses();
    if(!addrss.isEmpty())
    {
        QHostAddress addr;
        addr = addrss.first();
    }
    auto run = [host, port, this]() {
        if(socket() &&
            socket()->state() != QAbstractSocket::ConnectedState &&
            socket()->state() != QAbstractSocket::ConnectingState)
        {
            socket()->connectToHost(host, port);
        }
    };
    QTimer::singleShot(20, run);
    op_ = NetOp::Connect;
    execLoop(connectionTimeout_);
    op_ = NetOp::Invalid;
    return connectedToHost();
}

bool SyncSocketWrapper::disconnectFromHost()
{
    if(!socket_ || socket_->state() == QTcpSocket::UnconnectedState) return true;
    socket()->disconnectFromHost();
    if(socket_->state() == QTcpSocket::UnconnectedState) return true;
    op_ = NetOp::Connect;
    execLoop(connectionTimeout_);
    op_ = NetOp::Invalid;
    return !socket_ || socket_->state() == QTcpSocket::UnconnectedState;
}

QByteArray SyncSocketWrapper::sendMsg(const QByteArray &msg, ReadFunc reader)
{
    if(!connectedToHost()) return QByteArray();
    socket()->write(msg);
    socket()->flush();
    if(socket_ && socket_->bytesAvailable() <= 0)
    {
        op_ = NetOp::Exchange;
        execLoop(exchangeTimeout_);
        op_ = NetOp::Invalid;
    }
    if(!socket_ || socket_->bytesAvailable() <= 0)
    {
        // if(socket_)
        // {
        //     lmCWarning(log_) <<socketState() << socket_->bytesAvailable();
        // }
        return QByteArray();
    }
    return reader(socket_);
}

qint32 SyncSocketWrapper::exchangeTimeout() const
{
    return exchangeTimeout_;
}

void SyncSocketWrapper::setExchangeTimeout(qint32 newExchangeTimeout)
{
    exchangeTimeout_ = newExchangeTimeout;
    if(exchangeTimeout_ < 1000) exchangeTimeout_ = 10000;
}

qint32 SyncSocketWrapper::connectionTimeout() const
{
    return connectionTimeout_;
}

void SyncSocketWrapper::setConnectionTimeout(qint32 newConnectionTimeout)
{
    connectionTimeout_ = newConnectionTimeout;
    if(connectionTimeout_ < 1000) exchangeTimeout_ = 1000;
}

QAbstractSocket::SocketState SyncSocketWrapper::socketState() const
{
    return socket_ ? socket_->state() : QTcpSocket::UnconnectedState;
}

QTcpSocket *SyncSocketWrapper::socket()
{
    if(!socket_)
    {
        socket_ = new QTcpSocket(this);
        connect(socket_, &QTcpSocket::connected, this, &SyncSocketWrapper::connected);
        connect(socket_, &QTcpSocket::disconnected, this, &SyncSocketWrapper::disconnected);
        connect(socket_, &QTcpSocket::errorOccurred, this, &SyncSocketWrapper::errorOccurred);
        connect(socket_, &QTcpSocket::hostFound, this, &SyncSocketWrapper::hostFound);
        connect(socket_, &QTcpSocket::proxyAuthenticationRequired, this,
                &SyncSocketWrapper::proxyAuthenticationRequired);
        connect(socket_, &QTcpSocket::stateChanged, this, &SyncSocketWrapper::stateChanged);
        connect(socket_, &QTcpSocket::readyRead, this, &SyncSocketWrapper::readyRead);
    }
    return socket_;
}

QEventLoop *SyncSocketWrapper::loop()
{
    if(!loop_) loop_ = new QEventLoop(this);
    return loop_;
}

QTimer *SyncSocketWrapper::timer()
{
    if(!loopTimer_)
    {
        loopTimer_ = new QTimer(this);
        connect(loopTimer_, &QTimer::timeout, this, &SyncSocketWrapper::timeout);
        loopTimer_->setSingleShot(true);
    }
    return loopTimer_;
}

void SyncSocketWrapper::execLoop(qint32 timeout)
{

    timer()->start(timeout);
    timer_.invalidate();
    timer_.start();
    loop()->exec();
    if(loopTimer_)
    {
        loopTimer_->stop();
        loopTimer_->deleteLater();
        loopTimer_ = nullptr;
    }
}

void SyncSocketWrapper::timeout()
{
    /*if(!socket_ || socket_->bytesAvailable() > 0 || timer_.elapsed() >= exchangeTimeout()) */
    loop()->quit();
}

void SyncSocketWrapper::connected()
{
}

void SyncSocketWrapper::disconnected()
{
}

void SyncSocketWrapper::errorOccurred(QAbstractSocket::SocketError socketError)
{
}

void SyncSocketWrapper::hostFound()
{
}

void SyncSocketWrapper::proxyAuthenticationRequired(const QNetworkProxy &proxy, QAuthenticator *authenticator)
{
    Q_UNUSED(proxy)
    Q_UNUSED(authenticator)

}

void SyncSocketWrapper::stateChanged(QAbstractSocket::SocketState socketState)
{
    // if(socket_)lmCWarning(log_) << socket_->peerAddress() << socket_->peerPort();
    if(socketState == QTcpSocket::ConnectedState || socketState == QTcpSocket::UnconnectedState)
    {
        loop()->quit();
    }
}

void SyncSocketWrapper::readyRead()
{
    loop()->quit();
}
