#ifndef SYNCSOCKETWRAPPER_H
#define SYNCSOCKETWRAPPER_H

#include <QObject>
#include <QTcpSocket>
#include <QEventLoop>
#include <QTimer>
#include <functional>
#include <QElapsedTimer>



using ReadFunc=std::function<QByteArray (QTcpSocket *socket) >;

class SyncSocketWrapper : public QObject
{
    Q_OBJECT
    Q_DISABLE_COPY(SyncSocketWrapper)
public:
    explicit SyncSocketWrapper(QObject *parent = nullptr);
    ~SyncSocketWrapper() override;

    bool connectedToHost() const;


    bool connectToHost(const QString &host, quint16 port);
    bool disconnectFromHost();
    QByteArray sendMsg(const QByteArray &msg, ReadFunc reader);


    qint32 exchangeTimeout() const;
    void setExchangeTimeout(qint32 newExchangeTimeout);

    qint32 connectionTimeout() const;
    void setConnectionTimeout(qint32 newConnectionTimeout);


    QTcpSocket::SocketState socketState() const;

private:
    enum class NetOp: quint8 {
        Invalid = 0,
        Connect = 1,
        Exchange = 2
    };
    QTcpSocket *socket_ = nullptr;
    QEventLoop *loop_ = nullptr;
    QTimer *loopTimer_ = nullptr;
    QElapsedTimer timer_ = {};
    qint32 exchangeTimeout_ = 300000;
    qint32 connectionTimeout_ = 10000;
    NetOp op_ = NetOp::Invalid;

    QTcpSocket *socket();
    QEventLoop *loop();
    QTimer *timer();


    void execLoop(qint32 timeout);

private slots:
    void timeout();
    void connected();
    void disconnected();
    void errorOccurred(QAbstractSocket::SocketError socketError);
    void hostFound();
    void proxyAuthenticationRequired(const QNetworkProxy &proxy, QAuthenticator *authenticator);
    void stateChanged(QAbstractSocket::SocketState socketState);
    void readyRead();
};

#endif // SYNCSOCKETWRAPPER_H
