#ifndef BASEHTTPWORKER_H
#define BASEHTTPWORKER_H

#include "httpcashboxserviceapi.h"
#include "cashier.h"

#include <QObject>
#include <QtHttpServer>

class BaseHttpWorker : public QObject
{
    Q_OBJECT
    Q_DISABLE_COPY(BaseHttpWorker)

    static const QString API_PREFIX;
public:
    explicit BaseHttpWorker(QObject *parent = nullptr);
    ~BaseHttpWorker() override;

    QHttpServerResponse operator ()(const QHttpServerRequest &req);

protected:
    HttpCashboxServiceApi *api_;
    Cashier cashier_;

    virtual QHttpServerResponse exec(const QHttpServerRequest &req) = 0;

    virtual QHttpServerResponse sendOptions( )const;
    virtual void setHeaders(QHttpServerResponse &resp) const;

    virtual CoreApiResult login(const QHttpServerRequest &req);
    virtual bool needAutorizing(const QHttpServerRequest &req) const;


    QString getHttpResultDescription(int status) const;
    QString getHtmlResultAnswer(int status, const QString &text = QString()) const;
    QString getHtmlResultAnswer(QHttpServerResponse::StatusCode status, const QString &text = QString()) const;
    QByteArray getJsonResultAnswer(int status, const QString &text = QString()) const;
    QByteArray getJsonResultAnswer(QHttpServerResponse::StatusCode status, const QString &text = QString()) const;

    virtual QHttpServerResponse documentToResponse(const CoreApiResult &res) const;
    virtual QHttpServerResponse dataToResponse(const CoreApiResult &res, bool raw, const QString &name = QString()) const;

    QMap<QString, QString> getQueryItems(const QHttpServerRequest &req) const;
    CoreTransaction prepareTransaction(const QHttpServerRequest &req, QMap<QString, QString> &params) const;

    static QString getPath(const QString &name);
    QVariantMap lowHeaders(const QHttpServerRequest &req) const;


    QHttpServerResponse uploadFile(const QString &rootFolder, const QString &pathPrefix,
                                   qint32 maxSize, const QHttpServerRequest &req);
    QHttpServerResponse downloadFile(const QString &rootFolder, const QString &pathPrefix,
                                     const QHttpServerRequest &req);

    virtual QHttpServerResponse folderToHtml(const QString &folder, const QString &urlPrefix, bool images = true) const;
    virtual QHttpServerResponse folderToJson(const QString &folder, const QString &urlPrefix) const;

    QString transliterate(const QString &src) const;
};

#endif // BASEHTTPWORKER_H
