#include "cashboxstatushttpworker.h"

#include "cashboxbuildconfig.h"
#include "formatutils.h"

CashboxStatusHttpWorker::CashboxStatusHttpWorker(QObject *parent)
    : BaseHttpWorker(parent)
{

}

CashboxStatusHttpWorker::~CashboxStatusHttpWorker()
{

}

void CashboxStatusHttpWorker::initRoutes(QHttpServer *server)
{
    server->route(getPath("cashboxstatus.json"), [](const QHttpServerRequest &req) {
//        lmWarning() << req.url().toString();
        CashboxStatusHttpWorker w;
        return w(req);
    });
    server->route("/cashboxversion.json", [](const QHttpServerRequest &req) {
//        lmWarning() << req.url().toString();
        CashboxStatusHttpWorker w;
        return w(req);
    });
    server->route("/coreversion.json", [](const QHttpServerRequest &req) {
//        lmWarning() << req.url().toString();
        CashboxStatusHttpWorker w;
        return w(req);
    });
    server->route(getPath("cashboxstatus.html"), [](const QHttpServerRequest &req) {
//        lmWarning() << req.url().toString();
        CashboxStatusHttpWorker w;
        return w(req);
    });
    server->route(getPath("cashboxserial.json"), [](const QHttpServerRequest &req) {
//        lmWarning() << req.url().toString();
        CashboxStatusHttpWorker w;
        return w(req);
    });
    server->route(getPath("cashboxserial.html"), [](const QHttpServerRequest &req) {
//        lmWarning() << req.url().toString();
        CashboxStatusHttpWorker w;
        return w(req);
    });
    server->route(getPath("fscounters.json"), [](const QHttpServerRequest &req) {
//        lmWarning() << req.url().toString();
        CashboxStatusHttpWorker w;
        return w(req);
    });
    server->route(getPath("cyclecounters.json"), [](const QHttpServerRequest &req) {
//        lmWarning() << req.url().toString();
        CashboxStatusHttpWorker w;
        return w(req);
    });
    server->route(getPath("availablecashiernames.json"), [](const QHttpServerRequest &req) {
//        lmWarning() << req.url().toString();
        CashboxStatusHttpWorker w;
        return w(req);
    });
}

QHttpServerResponse CashboxStatusHttpWorker::exec(const QHttpServerRequest &req)
{
    Q_UNUSED(req)
    QMap<QString, QString>params = getQueryItems(req);
    bool raw = params.contains("raw") && params["raw"].toInt();

    if(req.url().path().startsWith("/cashboxversion.json"))
    {
        CoreApiResult res = api_->loadCashboxStatus(true);
        CashboxStatus st(res.data());
        res.setData(st.modelData().toExternalMap());
        return dataToResponse(res, raw, "modelData");
    }

    if(req.url().path().startsWith(getPath("cashboxstatus.json")))
    {
        CoreApiResult res = api_->loadCashboxStatus(!raw);
        return dataToResponse(res, raw, "status");
    }
    if(req.url().path().startsWith("/coreversion.json"))
    {

        QVariantMap data = {
            {"versionCode", CASHBOX_APP_VERSION_CODE},
            {"versionName", CASHBOX_APP_VERSION},
            {"buildDt", DT2STR_(CASHBOX_BUILD_DT)},
            {"ffd", "1.2"}
        };
        CoreApiResult res(CoreApiConst::ErrorCode::Ok, QString(), data);
        return dataToResponse(res, raw, "coreVersion");
    }

    if(req.url().path().startsWith(getPath("availablecashiernames.json")))
    {
        CoreTransaction transaction;
        transaction.setOperation(CoreTransaction::Operation::GET_CASHIER_NAMES);
        transaction.genUid();
//        lmWarning() << logvariant(transaction.toMap());
        CoreApiResult res = api_->exec(transaction);
//        lmWarning() << logvariant(res.toMap());
        return dataToResponse(res, raw, "");
    }

    if(req.url().path().startsWith(getPath("cashboxstatus.html")))
    {
        CoreApiResult res = api_->loadCashboxStatus(true);
        CashboxStatus st(res.data());
        return QHttpServerResponse("text/html", st.toHtml().toUtf8());
    }
    if(req.url().path().startsWith(getPath("cashboxserial.json")))
    {
        CoreApiResult res = api_->loadCashboxStatus(true);
        CashboxStatus st(res.data());
        res.setData(st.modelData().toExternalMap());
        return dataToResponse(res, raw, "modelData");
    }
    if(req.url().path().startsWith(getPath("cashboxserial.html")))
    {
        CoreApiResult res = api_->loadCashboxStatus(true);
        CashboxStatus st(res.data());
        return QHttpServerResponse("text/html", st.modelData().toHtml(true).toUtf8());
    }

    if(req.url().path().startsWith(getPath("fscounters.json")))
    {
        CoreTransaction trans = prepareTransaction(req, params);
        trans.setOperation(CoreTransaction::Operation::FS_COUNTERS);
        trans.setCashierLogin(cashier_.login());
        trans.setCashierPassword(cashier_.password());
        QVariantMap data;
        data["type"] = 1;
        trans.setParams(data);
        trans.setUid(trans.genUid());
        CoreApiResult res = api_->exec(trans);
        return dataToResponse(res, raw, "fsCounters");
    }
    if(req.url().path().startsWith(getPath("cyclecounters.json")))
    {
        CoreTransaction trans = prepareTransaction(req, params);
        trans.setOperation(CoreTransaction::Operation::FS_COUNTERS);
        trans.setCashierLogin(cashier_.login());
        trans.setCashierPassword(cashier_.password());
        QVariantMap data;
        data["type"] = 0;
        trans.setParams(data);
        trans.setUid(trans.genUid());
        CoreApiResult res = api_->exec(trans);
        return dataToResponse(res, raw, "cycleCounters");
    }
    return QHttpServerResponse(QHttpServerResponse::StatusCode::NotFound);
}

bool CashboxStatusHttpWorker::needAutorizing(const QHttpServerRequest &req) const
{
    return !req.url().path().startsWith(getPath("availablecashiernames.json")) &&
           !req.url().path().startsWith(getPath("cashboxstatus.json")) &&
            !req.url().path().startsWith("coreversion.json");
}
