#include "cyclehttpworker.h"

#include "cycleopendoc.h"
#include "cycleclosedoc.h"
#include "fsclosedoc.h"

#include <QJsonDocument>
#include <QJsonParseError>

CycleHttpWorker::CycleHttpWorker(QObject *parent)
    : BaseHttpWorker(parent)
{

}

CycleHttpWorker::~CycleHttpWorker()
{

}

void CycleHttpWorker::initRoutes(QHttpServer *server)
{
    server->route(getPath("cycleopen.json"), [](const QHttpServerRequest &req) {
//        lmWarning() << req.url().toString();
        CycleHttpWorker w;
        return w(req);
    });

    server->route(getPath("calcreport.json"), [](const QHttpServerRequest &req) {
//        lmWarning() << req.url().toString();
        CycleHttpWorker w;
        return w(req);
    });
    server->route(getPath("cycleclose.json"), [](const QHttpServerRequest &req) {
//        lmWarning() << req.url().toString();
        CycleHttpWorker w;
        return w(req);
    });
    server->route(getPath("fsclose.json"), [](const QHttpServerRequest &req) {
//        lmWarning() << req.url().toString();
        CycleHttpWorker w;
        return w(req);
    });
}

QHttpServerResponse CycleHttpWorker::exec(const QHttpServerRequest &req)
{
    if(req.method() == QHttpServerRequest::Method::POST) return execPost(req);
    if(req.method() == QHttpServerRequest::Method::GET) return execGet(req);
    return QHttpServerResponse::StatusCode::NotFound;
}

QHttpServerResponse CycleHttpWorker::execPost(const QHttpServerRequest &req)
{
    QHttpServerResponse res(QHttpServerResponse::StatusCode::NotFound);
    CoreTransaction trans;
    if(!postReqToTransaction(req, trans, res)) return res;

    CoreApiResult result = api_->exec(trans);
    return trans.formatToExternal() ? documentToResponse(result) : dataToResponse(result, false, "data");
}

QHttpServerResponse CycleHttpWorker::execGet(const QHttpServerRequest &req)
{
    QHttpServerResponse res(QHttpServerResponse::StatusCode::NotFound);
    CoreTransaction trans;
    if(!getReqToTransaction(req, trans, res)) return res;

    CoreApiResult result = api_->exec(trans);
        return trans.formatToExternal() ? documentToResponse(result) : dataToResponse(result, false, "data");

}

bool CycleHttpWorker::postReqToTransaction(const QHttpServerRequest &req, CoreTransaction &trans, QHttpServerResponse &resp)
{
    QMap<QString, QString> params;
    trans = prepareTransaction(req, params);
    if(req.url().path().toLower().startsWith(getPath("cycleopen")))
    {
        trans.setOperation(CoreTransaction::Operation::OPEN_CYCLE);
    }
    else if(req.url().path().toLower().startsWith(getPath("calcreport")))
    {
        trans.setOperation(CoreTransaction::Operation::CALC_REPORT);
    }
    else if(req.url().path().toLower().startsWith(getPath("cycleclose")))
    {
        trans.setOperation(CoreTransaction::Operation::CLOSE_CYCLE);
    }
    else if(req.url().path().toLower().startsWith(getPath("fsclose")))
    {
        trans.setOperation(CoreTransaction::Operation::FS_CLOSE);
    }
    else
    {
        resp = QHttpServerResponse(QHttpServerResponse::StatusCode::NotFound);
        return false;
    }

    QJsonParseError jerr;
    QJsonDocument jdoc = QJsonDocument::fromJson(req.body(), &jerr);
    if(jerr.error != QJsonParseError::NoError)
    {
        resp = QHttpServerResponse(QHttpServerResponse::StatusCode::BadRequest);
        return false;
    }
    trans.setParams(jdoc.toVariant().toMap());
    trans.setParams(trans.params().value("document").toMap());
    trans.setCashierLogin(cashier_.login());
    trans.setCashierPassword(cashier_.password());
    trans.setUid(trans.genUid());
    return true;
}

bool CycleHttpWorker::getReqToTransaction(const QHttpServerRequest &req, CoreTransaction &trans, QHttpServerResponse &resp)
{
    QMap<QString, QString> params;
    trans = prepareTransaction(req, params);
    QVariantMap document;
    if(req.url().path().toLower().startsWith(getPath("cycleopen")))
    {
        trans.setOperation(CoreTransaction::Operation::OPEN_CYCLE);
        CycleOpenIncoming inc;
        inc.setCashier(cashier_.name());
        document = inc.toMap();
    }
    else if(req.url().path().toLower().startsWith(getPath("calcreport")))
    {
        trans.setOperation(CoreTransaction::Operation::CALC_REPORT);
    }
    else if(req.url().path().toLower().startsWith(getPath("cycleclose")))
    {
        trans.setOperation(CoreTransaction::Operation::CLOSE_CYCLE);
        CycleCloseIncoming inc;
        inc.setCashier(cashier_.name());
        document = inc.toMap();
    }
    else if(req.url().path().toLower().startsWith(getPath("fsclose")))
    {
        trans.setOperation(CoreTransaction::Operation::FS_CLOSE);
        FsCloseIncoming inc;
        inc.setCashier(cashier_.name());
        document = inc.toMap();
    }
    else
    {
        resp = QHttpServerResponse(QHttpServerResponse::StatusCode::NotFound);
        return false;
    }
    QVariantMap data;
    data["document"] = document;
    trans.setParams(data);
    trans.setCashierLogin(cashier_.login());
    trans.setCashierPassword(cashier_.password());
    trans.setUid(trans.genUid());
    return true;
}

