#ifndef CYCLEHTTPWORKER_H
#define CYCLEHTTPWORKER_H

#include "basehttpworker.h"

class CycleHttpWorker : public BaseHttpWorker
{
    Q_OBJECT
    Q_DISABLE_COPY(CycleHttpWorker)
public:
    explicit CycleHttpWorker(QObject *parent = nullptr);
    ~CycleHttpWorker()override;
    static void initRoutes(QHttpServer *server);
private:
    QHttpServerResponse exec(const QHttpServerRequest &req) override;
    QHttpServerResponse execPost(const QHttpServerRequest &req);
    QHttpServerResponse execGet(const QHttpServerRequest &req);

    bool postReqToTransaction(const QHttpServerRequest &req, CoreTransaction &trans, QHttpServerResponse &resp);
    bool getReqToTransaction(const QHttpServerRequest &req, CoreTransaction &trans, QHttpServerResponse &resp);

};

#endif // CYCLEHTTPWORKER_H
