#include "fiscalhttpworker.h"

FiscalHttpWorker::FiscalHttpWorker(QObject *parent)
    : BaseHttpWorker(parent)
{

}

FiscalHttpWorker::~FiscalHttpWorker()
{

}

void FiscalHttpWorker::initRoutes(QHttpServer *server)
{
    server->route(getPath("registrate.json"), [](const QHttpServerRequest &req) {
//        lmWarning() << req.url().toString();
        FiscalHttpWorker w;
        return w(req);
    });
    server->route(getPath("writeserial.json"), [](const QHttpServerRequest &req) {
        //        lmWarning() << req.url().toString();
        FiscalHttpWorker w;
        return w(req);
    });
}

QHttpServerResponse FiscalHttpWorker::exec(const QHttpServerRequest &req)
{
    if(req.method() != QHttpServerRequest::Method::Post)
    {
        return QHttpServerResponse::StatusCode::NotFound;
    }
    QJsonParseError jerr;
    QJsonDocument jdoc = QJsonDocument::fromJson(req.body(), &jerr);
    if(jerr.error != QJsonParseError::NoError)
    {
        return QHttpServerResponse::StatusCode::BadRequest;
    }
    QVariantMap body = jdoc.toVariant().toMap();
    if(body.contains("document"))body = body["document"].toMap();
    else
    {
        return QHttpServerResponse::StatusCode::NotAcceptable;
    }

    CoreApiResult res = api_->exec(reqToTransaction(req, body));
    return documentToResponse(res);
}

CoreTransaction FiscalHttpWorker::reqToTransaction(const QHttpServerRequest &req, QVariantMap &body)
{
    QMap<QString, QString> params;
    CoreTransaction trans = prepareTransaction(req, params);
    if(req.url().path().toLower().startsWith(getPath("registrate")))
    {
        trans.setOperation(CoreTransaction::Operation::FISCALIZATION);
        trans.setParams(body);
    }
    else if(req.url().path().toLower().startsWith(getPath("fsclose")))
    {
        trans.setOperation(CoreTransaction::Operation::FS_CLOSE);
        trans.setParams(body);
    }
    else if(req.url().path().toLower().startsWith(getPath("writeserial")))
    {
        trans.setOperation(CoreTransaction::Operation::WRITE_SERIAL);
        trans.setParams(body);
    }
    trans.setCashierLogin(cashier_.login());
    trans.setCashierPassword(cashier_.password());
    trans.setUid(trans.genUid());
    return trans;
}
