#include "httpworkersfactory.h"

#include "cashboxstatushttpworker.h"
#include "fiscalhttpworker.h"
#include "cyclehttpworker.h"
#include "reportshttpworker.h"
#include "servicehttpworker.h"
#include "receiptshttpworker.h"


void HttpWorkersFactory::initHttpServer(QHttpServer *server)
{
    if(server)
    {

        CashboxStatusHttpWorker::initRoutes(server);
        FiscalHttpWorker::initRoutes(server);
        CycleHttpWorker::initRoutes(server);
        ReportsHttpWorker::initRoutes(server);
        ServiceHttpWorker::initRoutes(server);
        ReceiptsHttpWorker::initRoutes(server);
        server->route("/*", [](const QHttpServerRequest &req) {
            return QHttpServerResponse::StatusCode::NotFound;
        });
    }
}

HttpWorkersFactory::HttpWorkersFactory()
{

}

