#include "printhttpworker.h"
#include "appdirectories.h"



PrintHttpWorker::PrintHttpWorker(QObject *parent)
    : BaseHttpWorker(parent)
{

}

PrintHttpWorker::~PrintHttpWorker()
{

}

void PrintHttpWorker::initRoutes(QHttpServer *server)
{
    server->route(getPath("images/<arg>"), [](const QString &file, const QHttpServerRequest &req) {
        PrintHttpWorker w;
        return w(req);
    });
    server->route(getPath("images"), [](const QHttpServerRequest &req) {
        PrintHttpWorker w;
        return w(req);
    });
    server->route(getPath("images/"), [](const QHttpServerRequest &req) {
        PrintHttpWorker w;
        return w(req);
    });
    server->route(getPath("print/<arg>"), [](const QString &file, const QHttpServerRequest &req) {
        PrintHttpWorker w;
        return w(req);
    });
}

QHttpServerResponse PrintHttpWorker::exec(const QHttpServerRequest &req)
{
    if(req.method() == QHttpServerRequest::Method::POST) return execPost(req);
    if(req.method() == QHttpServerRequest::Method::GET) return execGet(req);
    return QHttpServerResponse::StatusCode::NotFound;
}

QHttpServerResponse PrintHttpWorker::execPost(const QHttpServerRequest &req)
{
    if(req.url().path().toLower().startsWith(getPath("images")))
    {
        return uploadFile(APATH.imagesPath(), "images", MAX_IMG_SIZE, req);
    }
    if(req.url().path().toLower().startsWith(getPath("print")))
    {
        if(req.url().path().toLower().endsWith(".bb"))
        {
            QMap<QString, QString> params;
            CoreTransaction trans = prepareTransaction(req, params);
            QVariantMap data;
            data["bbcode"] = QString::fromUtf8(req.body());
            trans.setParams(data);
            trans.setOperation(CoreTransaction::Operation::PRINT_TEXT);
            trans.setCashierLogin(cashier_.login());
            trans.setCashierPassword(cashier_.password());
            trans.genUid();
            CoreApiResult res = api_->exec(trans);
            return dataToResponse(res, false, "");
        }
        else if(req.url().path().toLower().endsWith(".txt"))
        {
            QMap<QString, QString> params;
            CoreTransaction trans = prepareTransaction(req, params);
            QVariantMap data;
            QStringList body = QString::fromUtf8(req.body()).split("\n");
            for(QString &s: body)
            {
                if(s.isEmpty()) s = "    ";
                s = "[left]" + s + "[/left]";
            }
            data["bbcode"] = body.join("\n");
            trans.setParams(data);
            trans.setOperation(CoreTransaction::Operation::PRINT_TEXT);
            trans.setCashierLogin(cashier_.login());
            trans.setCashierPassword(cashier_.password());
            trans.genUid();
            CoreApiResult res = api_->exec(trans);
            return dataToResponse(res, false, "");
        }

    }
    return QHttpServerResponse::StatusCode::NotFound;
}

QHttpServerResponse PrintHttpWorker::execGet(const QHttpServerRequest &req)
{
    if(req.url().path().toLower().startsWith(getPath("images")))
    {
        return downloadFile(APATH.imagesPath(), "images", req);
    }
    return QHttpServerResponse::StatusCode::NotFound;

}
