#include "receiptshttpworker.h"

#include "cashboxbuildconfig.h"

ReceiptsHttpWorker::ReceiptsHttpWorker(QObject *parent)
    : BaseHttpWorker(parent)
{

}

ReceiptsHttpWorker::~ReceiptsHttpWorker()
{

}

void ReceiptsHttpWorker::initRoutes(QHttpServer *server)
{
    server->route(getPath("receipt.json"), [](const QHttpServerRequest &req) {
        ReceiptsHttpWorker w;
        return w(req);
    });
    server->route(getPath("correction.json"), [](const QHttpServerRequest &req) {
        ReceiptsHttpWorker w;
        return w(req);
    });
    server->route(getPath("labelcheck.json"), [](const QHttpServerRequest &req) {
        ReceiptsHttpWorker w;
        return w(req);
    });
    server->route(getPath("startlabelschecksession.json"), [](const QHttpServerRequest &req) {
        ReceiptsHttpWorker w;
        return w(req);
    });
}

QHttpServerResponse ReceiptsHttpWorker::exec(const QHttpServerRequest &req)
{
    if(req.method() == QHttpServerRequest::Method::GET)
    {
        QMap<QString, QString> params;
        CoreTransaction trans = prepareTransaction(req, params);
        bool raw = params.contains("raw") && params["raw"].toInt();
        if(req.url().path().toLower().startsWith(getPath("startlabelschecksession")))
        {
            trans.setOperation(CoreTransaction::Operation::CLEAN_LABELS);
            trans.setParams({});
        }
        else
        {
            return QHttpServerResponse(QHttpServerResponse::StatusCode::NotFound);
        }
        trans.setCashierLogin(cashier_.login());
        trans.setCashierPassword(cashier_.password());
        trans.setUid(trans.genUid());

        CoreApiResult result = api_->exec(trans);
        return dataToResponse(result, raw);
    }

    if(req.method() != QHttpServerRequest::Method::POST) return QHttpServerResponse::StatusCode::NotFound;
    QJsonParseError jerr;
    QJsonDocument jdoc = QJsonDocument::fromJson(req.body(), &jerr);
    QVariantMap data = jdoc.toVariant().toMap();
    data = data["document"].toMap();
    QMap<QString, QString> params;
    CoreTransaction trans = prepareTransaction(req, params);
    bool raw = params.contains("raw") && params["raw"].toInt();
    if(jerr.error != QJsonParseError::NoError)
    {
        return QHttpServerResponse(QHttpServerResponse::StatusCode::BadRequest);
    }
    if(req.url().path().toLower().startsWith(getPath("receipt")))
    {
        trans.setOperation(CoreTransaction::Operation::RECEIPT);
    }
    else if(req.url().path().toLower().startsWith(getPath("correction")))
    {
        trans.setOperation(CoreTransaction::Operation::CORRECTION);
    }
    else if(req.url().path().toLower().startsWith(getPath("labelcheck")))
    {
        trans.setOperation(CoreTransaction::Operation::CHECK_LABEL);
    }
    else if(req.url().path().toLower().startsWith(getPath("startlabelschecksession")))
    {
        trans.setOperation(CoreTransaction::Operation::CLEAN_LABELS);
    }
    else
    {
        return QHttpServerResponse(QHttpServerResponse::StatusCode::NotFound);
    }
    trans.setParams(data);
    trans.setCashierLogin(cashier_.login());
    trans.setCashierPassword(cashier_.password());
    trans.setUid(trans.genUid());

    CoreApiResult result = api_->exec(trans);
     return dataToResponse(result, raw, "document");
}
