#ifndef REPORTSHTTPWORKER_H
#define REPORTSHTTPWORKER_H

#include "basehttpworker.h"

class ReportsHttpWorker : public BaseHttpWorker
{
    Q_OBJECT
    Q_DISABLE_COPY(ReportsHttpWorker)
public:
    explicit ReportsHttpWorker(QObject *parent = nullptr);
    ~ReportsHttpWorker() override;

    static void initRoutes(QHttpServer *server);

    QHttpServerResponse exec(const QHttpServerRequest &req) override;
    QHttpServerResponse execPost(const QHttpServerRequest &req);
    QHttpServerResponse execGet(const QHttpServerRequest &req);

    bool getReqToTransaction(const QHttpServerRequest &req, CoreTransaction &trans, QHttpServerResponse &resp);
    bool postReqToTransaction(const QHttpServerRequest &req, CoreTransaction &trans, QHttpServerResponse &resp);

    QHttpServerResponse offlineNotifications(const QHttpServerRequest &req);
};

#endif // REPORTSHTTPWORKER_H
