#include "servicehttpworker.h"
#include "firmwaremanipulator.h"
#include "cashboxbuildconfig.h"
#include "devicehelper.h"

#include <QBuffer>
#include <QCoreApplication>

ServiceHttpWorker::ServiceHttpWorker(QObject *parent)
    : BaseHttpWorker(parent)
{

}

ServiceHttpWorker::~ServiceHttpWorker()
{

}

void ServiceHttpWorker::initRoutes(QHttpServer *server)
{
    server->route(getPath("login.json"), [](const QHttpServerRequest &req) {
        ServiceHttpWorker w;
        return w(req);
    });

    server->route(getPath("getdataforreceipt.json"), [](const QHttpServerRequest &req) {
        ServiceHttpWorker w;
        return w(req);
    });
    server->route(getPath("fsclean.json"), [](const QHttpServerRequest &req) {
        ServiceHttpWorker w;
        return w(req);
    });
    server->route(getPath("savecashier.json"), [](const QHttpServerRequest &req) {
        ServiceHttpWorker w;
        return w(req);
    });
    server->route(getPath("loadcashiers.json"), [](const QHttpServerRequest &req) {
        ServiceHttpWorker w;
        return w(req);
    });
    server->route(getPath("removecashier.json"), [](const QHttpServerRequest &req) {
        ServiceHttpWorker w;
        return w(req);
    });

    server->route(getPath("loadofdcfg.json"), [](const QHttpServerRequest &req) {
        ServiceHttpWorker w;
        return w(req);
    });
    server->route(getPath("saveofdcfg.json"), [](const QHttpServerRequest &req) {
        ServiceHttpWorker w;
        return w(req);
    });
    server->route(getPath("fullclear.json"), [](const QHttpServerRequest &req) {
        ServiceHttpWorker w;
        return w(req);
    });
    server->route(getPath("setdatetime.json"), [](const QHttpServerRequest &req) {
        ServiceHttpWorker w;
        return w(req);
    });
    server->route(getPath("firmware.pkg"), [](const QHttpServerRequest &req) {
        ServiceHttpWorker w;
        return w(req);
    });
}

QHttpServerResponse ServiceHttpWorker::exec(const QHttpServerRequest &req)
{
    if(req.method() == QHttpServerRequest::Method::POST) return execPost(req);
    if(req.method() == QHttpServerRequest::Method::GET) return execGet(req);
    return QHttpServerResponse::StatusCode::NotFound;
}

QHttpServerResponse ServiceHttpWorker::execPost(const QHttpServerRequest &req)
{

    if(req.url().path().toLower().startsWith(getPath("firmware.pkg")))
    {
        FirmwareManipulator m;
        QBuffer b;
        b.open(QIODevice::WriteOnly);
        b.write(req.body());
        b.close();
        b.open(QIODevice::ReadWrite);
        quint32 versionCode = 0;
        QString versionName;
        bool res = m.decryptFile(&b, "/tmp/unitcore", FirmwareManipulator::D, FirmwareManipulator::N, versionCode, versionName);
        if(res)
        {
            DeviceHelper().updateTo("/tmp/unitcore");
        }
        return QHttpServerResponse(res ? QHttpServerResponse::StatusCode::Ok : QHttpServerResponse::StatusCode::BadRequest);
    }

    QJsonParseError jerr;
    QJsonDocument jdoc = QJsonDocument::fromJson(req.body(), &jerr);
    if(jerr.error != QJsonParseError::NoError)
    {
        return QHttpServerResponse::StatusCode::BadRequest;
    }
    QVariantMap data = jdoc.toVariant().toMap();
    QMap<QString, QString>params = getQueryItems(req);
    bool raw = params.contains("raw") && params["raw"].toInt();
    CoreTransaction trans;
    trans.setCashierLogin(cashier_.login());
    trans.setCashierPassword(cashier_.password());
    if(req.url().path().toLower().startsWith(getPath("savecashier.json")))
    {
//        lmWarning() << logvariant(data) << logtab << req.body();
        trans.setOperation(CoreTransaction::Operation::SAVE_CASHIER);
        if(!data.contains("cashier"))
        {
            return QHttpServerResponse::StatusCode::BadRequest;
        }
        trans.setParams(data["cashier"].toMap());
        trans.genUid();
        CoreApiResult res = api_->exec(trans);
        return dataToResponse(res, raw, "cashier");
    }
    if(req.url().path().toLower().startsWith(getPath("saveofdcfg.json")))
    {
        trans.setOperation(CoreTransaction::Operation::SAVE_OFD_SETTINGS);
        if(!data.contains("ofd"))
        {
            return QHttpServerResponse::StatusCode::BadRequest;
        }
        trans.setParams(data["ofd"].toMap());
        trans.genUid();
        CoreApiResult res = api_->exec(trans);
        return dataToResponse(res, raw, "ofd");
    }
    if(req.url().path().toLower().startsWith(getPath("setdatetime.json")))
    {
        trans.setOperation(CoreTransaction::Operation::SET_DATE_TIME);
        if(!data.contains("dt"))
        {
            return QHttpServerResponse::StatusCode::BadRequest;
        }
        trans.setParams(data);
        trans.genUid();
        CoreApiResult res = api_->exec(trans);
        return dataToResponse(res, raw, "");
    }

    return  QHttpServerResponse::StatusCode::NotFound;
}

QHttpServerResponse ServiceHttpWorker::execGet(const QHttpServerRequest &req)
{
    QMap<QString, QString>params = getQueryItems(req);
    bool raw = params.contains("raw") && params["raw"].toInt();

    if(req.url().path().startsWith(getPath("login.json")))
    {
        CoreApiResult res = login(req);
        if(!raw)
        {
            res.setData(Cashier(res.data()).toExternalMap(false));
        }

        return dataToResponse(res, raw, "cashier");
    }
    if(req.url().path().toLower().startsWith(getPath("getdataforreceipt.json")))
    {
        CoreTransaction transaction;
        transaction.setOperation(CoreTransaction::Operation::GET_DATA_FOR_RECEIPT);
        transaction.genUid();
        transaction.setCashierLogin(cashier_.login());
        transaction.setCashierPassword(cashier_.password());
//        lmWarning() << logvariant(transaction.toMap());
        CoreApiResult res = api_->exec(transaction);
//        lmWarning() << logvariant(res.toMap());
        return dataToResponse(res, raw, "");
    }
    if(req.url().path().toLower().startsWith(getPath("fsclean.json")))
    {
        CoreTransaction trans = prepareTransaction(req, params);
        trans.setOperation(CoreTransaction::Operation::FS_CLEAN);
        trans.setCashierLogin(cashier_.login());
        trans.setCashierPassword(cashier_.password());
        trans.setUid(trans.genUid());
        CoreApiResult res = api_->exec(trans);
        return dataToResponse(res, raw, "");
    }
    if(req.url().path().toLower().startsWith(getPath("loadcashiers.json")))
    {
        CoreTransaction trans = prepareTransaction(req, params);
        trans.setOperation(CoreTransaction::Operation::DOWNLOAD_CASHIERS);
        trans.setCashierLogin(cashier_.login());
        trans.setCashierPassword(cashier_.password());
//        lmWarning() << params;
        if(params.contains("cashierid"))
        {
            QVariantMap data;
            data["cashierId"] = params["cashierid"].toInt();
            trans.setParams(data);
        }
        trans.setUid(trans.genUid());
        CoreApiResult res = api_->exec(trans);
        return dataToResponse(res, raw, "");
    }
    if(req.url().path().toLower().startsWith(getPath("removecashier.json")))
    {
        CoreTransaction trans = prepareTransaction(req, params);
//        lmWarning() << params;
        QVariantMap data;
        data["cashierId"] = params["cashierid"].toInt();
        trans.setOperation(CoreTransaction::Operation::REMOVE_CASHIER);
        trans.setCashierLogin(cashier_.login());
        trans.setCashierPassword(cashier_.password());
        trans.setParams(data);
        trans.setUid(trans.genUid());
        CoreApiResult res = api_->exec(trans);
        return dataToResponse(res, raw, "");
    }
    if(req.url().path().toLower().startsWith(getPath("loadofdcfg.json")))
    {
        CoreTransaction trans = prepareTransaction(req, params);
        trans.setOperation(CoreTransaction::Operation::LOAD_OFD_SETTINGS);
        trans.setCashierLogin(cashier_.login());
        trans.setCashierPassword(cashier_.password());
        trans.setUid(trans.genUid());
        CoreApiResult res = api_->exec(trans);
        return dataToResponse(res, raw, "ofd");
    }
    if(req.url().path().toLower().startsWith(getPath("fullclear.json")))
    {
        QString user;
        QString password;
        QByteArray auth = req.headers()["Authorization"].toString().toUtf8();
        if((auth.isEmpty() || !auth.startsWith("Basic ")))
        {
            QHttpServerResponse response(
                "application/json",
                getJsonResultAnswer(QHttpServerResponse::StatusCode::Unauthorized,
                                    QString()),
                QHttpServerResponse::StatusCode::Unauthorized);
            response.setHeader("WWW-Authenticate", "Basic realm=\"nmrs_m7VKmomQ2YM3:\"");
            return response;
        }
        else
        {
            auth = QByteArray::fromBase64(auth.mid(6).trimmed());
            QString sauth = QString::fromUtf8(auth);
            user = sauth.mid(0, sauth.indexOf(":"));
            password = sauth.mid(sauth.indexOf(":") + 1);
        }
        CoreTransaction trans = prepareTransaction(req, params);
        trans.setOperation(CoreTransaction::Operation::FULL_CLEAR);
        trans.setCashierLogin(user);
        trans.setCashierPassword(password);
        trans.setUid(trans.genUid());

        CoreApiResult res = api_->exec(trans);
        if(res.code() == CoreApiConst::ErrorCode::AccessDenied)
        {
            QHttpServerResponse response(
                "application/json",
                getJsonResultAnswer(QHttpServerResponse::StatusCode::Unauthorized,
                                    res.descr()),
                QHttpServerResponse::StatusCode::Unauthorized);
            response.setHeader("WWW-Authenticate", "Basic realm=\"nmrs_m7VKmomQ2YM3:\"");
            return response;
        }
        return dataToResponse(res, raw, "");
    }
    if(req.url().path().toLower().startsWith(getPath("firmware.pkg")))
    {
        FirmwareManipulator m;
        QBuffer b;
        b.open(QIODevice::WriteOnly);
        m.encryptFile(QCoreApplication::applicationFilePath(), &b,
                      static_cast<quint32>(CASHBOX_APP_VERSION_CODE), QString(CASHBOX_APP_VERSION),
                      FirmwareManipulator::E, FirmwareManipulator::N);        
        return QHttpServerResponse(b.data());
    }

    return QHttpServerResponse::StatusCode::NotFound;
}

bool ServiceHttpWorker::needAutorizing(const QHttpServerRequest &req) const
{
    return !req.url().path().toLower().startsWith(getPath("fullclear.json"));
}

