#ifndef SERVICEHTTPWORKER_H
#define SERVICEHTTPWORKER_H

#include "basehttpworker.h"

class ServiceHttpWorker : public BaseHttpWorker
{
    Q_OBJECT
    Q_DISABLE_COPY(ServiceHttpWorker);
public:
    explicit ServiceHttpWorker(QObject *parent = nullptr);
    ~ServiceHttpWorker() override;

    static void initRoutes(QHttpServer *server);
private:
    QHttpServerResponse exec(const QHttpServerRequest &req) override;

    QHttpServerResponse execPost(const QHttpServerRequest &req);
    QHttpServerResponse execGet(const QHttpServerRequest &req);
    bool needAutorizing(const QHttpServerRequest &req) const override;

};

#endif // SERVICEHTTPWORKER_H
