#ifndef FSWRAPPER_H
#define FSWRAPPER_H

#include "fsmsg.h"
#include "tlv.h"

#include "coreapiconst.h"
#include "fdfconstants.h"
#include "inn.h"
#include "regnumber.h"
#include "regdata.h"
#include "fscounters.h"
#include "ofdfscmd.h"
#include "fsarchivereportbase.h"
#include "regdoc.h"
#include "labelcode.h"

#include <QObject>
#include <QPointer>
#include <optional>

class FsApi;

class FsWrapper: public QObject
{
    Q_OBJECT
    Q_DISABLE_COPY(FsWrapper)
public:
    explicit FsWrapper(QObject *parent = nullptr);
    ~FsWrapper() override;

    bool open();
    void close();
    bool isOpen() const;

    CoreApiConst::ErrorCode getFullFsStatus(FsFullStatus &status,
                                            const fdf::RegFlags &flags,
                                            const fdf::RegFlags1290 &extFlags);
    CoreApiConst::ErrorCode getFsStatus(std::optional<FsStatus> &status);
    CoreApiConst::ErrorCode getFsNumber(QString &serial);
    CoreApiConst::ErrorCode getFsLifeTime(std::optional<FsLifeTime> &lt);
    CoreApiConst::ErrorCode getFsVersion(QString &version, bool &isRelease);
    CoreApiConst::ErrorCode getFsLastErrors(QByteArray &dump);
    CoreApiConst::ErrorCode getFsRelease(QString &release);
    CoreApiConst::ErrorCode getFsFormat(fs::FFD &curFfd, fs::FFD &supportedFfd);
    CoreApiConst::ErrorCode getFsLifedays(qint32 &days, const QDateTime &dt = QDateTime::currentDateTime());
    CoreApiConst::ErrorCode getFMemResource(std::optional<FsMemResourceInfo> &resource);
    CoreApiConst::ErrorCode getFsCycle(std::optional<CycleStatus> &cycle);
    CoreApiConst::ErrorCode getFsTransport(std::optional<FsTransportState> &st);
    CoreApiConst::ErrorCode cleanDebugFs();
    CoreApiConst::ErrorCode cancelDoc();
    CoreApiConst::ErrorCode sendDocData(const QByteArray &data);
    CoreApiConst::ErrorCode sendDocData(const Tlv::Stlv &list);
    CoreApiConst::ErrorCode readRegTlv(quint8 seq, fdf::Tag tag, Tlv&val);
    CoreApiConst::ErrorCode readTlvDoc(quint32 docNumber, quint16 &type, Tlv::Stlv &list);
    CoreApiConst::ErrorCode readRegData(quint8 seq, RegData &rd);
    CoreApiConst::ErrorCode readRegDoc(quint8 seq, BaseRegDoc *rd);
    CoreApiConst::ErrorCode readFsCounters(FsTotalType type, FsCounters &counters);
    CoreApiConst::ErrorCode readBStatus(BStatus &status);
    CoreApiConst::ErrorCode readBStatus2(bool &canSkipB5);
    CoreApiConst::ErrorCode readLabelsTransport(std::optional<LabelsTransportState> &status);


    CoreApiConst::ErrorCode writeTransportStaus(bool connected);
    CoreApiConst::ErrorCode cancelMessageForOfd();
    CoreApiConst::ErrorCode readMessageForOfd(QByteArray &data);
    CoreApiConst::ErrorCode writeOfdTicket(const QByteArray &data, quint8 &fsAnswer,
                                           quint8 &ofdAnswer, Tlv &ofdMsg, QByteArray &errDump);



    CoreApiConst::ErrorCode startFiscalization(fs::RegType regType, fs::FFD ffd);
    CoreApiConst::ErrorCode completeFiscalization(const QDateTime &dt,
                                                  const Inn &userInn,
                                                  const RegNumber &regNumber,
                                                  const fdf::Taxes &taxes,
                                                  const fs::RegFlags &flags,
                                                  const fs::ExtRegFlags &extFlags,
                                                  const Inn &innOfd,
                                                  qint32 &fd, quint32 &fiscCode,
                                                  fdf::Reasons *reasons = nullptr);

    CoreApiConst::ErrorCode openCycleStart(const QDateTime &dt);
    CoreApiConst::ErrorCode openCycleCommit(quint16 &cycle, qint32 &fd, quint32 &fiscCode);

    CoreApiConst::ErrorCode calcReportStart(const QDateTime &dt);
    CoreApiConst::ErrorCode calcReportCommit(qint32 &fd, quint32 &fiscCode,
                                             quint32 &notSended, QDate &notSendedDt);

    CoreApiConst::ErrorCode closeCycleStart(const QDateTime &dt);
    CoreApiConst::ErrorCode closeCycleCommit(quint16 &cycle, qint32 &fd, quint32 &fiscCode, fs::Warnings &warnings);
    CoreApiConst::ErrorCode closeFsStart();
    CoreApiConst::ErrorCode closeFsCommit(const QDateTime &dt, const RegNumber &rnm,
                                          qint32 &fd, quint32 &fiscCode);

    CoreApiConst::ErrorCode receiptStart(const QDateTime &dt);
    CoreApiConst::ErrorCode correctionStart(const QDateTime &dt);
    CoreApiConst::ErrorCode receiptCommit(const QDateTime &dt, fdf::PaymentType pt, const FixNumber &amount,
                                          quint16 &receipt, qint32 &fd, quint32 &fiscalCode);



    CoreApiConst::ErrorCode getKeysAddress(bool test, fs::KeysStatus &ks, QString &addr);
    CoreApiConst::ErrorCode getKeysData(const QDateTime &dt, QByteArray &data);
    CoreApiConst::ErrorCode writeKeysData(const QByteArray &data, quint8 &fsAnswer, quint16 &srvAns, QString &srvMsg);

    CoreApiConst::ErrorCode  b1(fdf::LabelCodeType lct, const QByteArray &code,
                                quint8 offcet91, quint8 offfcet92,
                                fdf::LabelCodeCheckFsResult &r, fdf::LabelCodeCheckFsStatus &s);
    CoreApiConst::ErrorCode  b1(const LabelCode &code,
                                fdf::LabelCodeCheckFsResult &r, fdf::LabelCodeCheckFsStatus &s);

    CoreApiConst::ErrorCode b2(bool saveResult, fdf::CheckLabelFlags &flags);
    CoreApiConst::ErrorCode b2Cancel();
    CoreApiConst::ErrorCode b3();
    CoreApiConst::ErrorCode b5(const QDateTime &dt, const Tlv::Stlv &in, QByteArray &out);
    CoreApiConst::ErrorCode b6(const QByteArray &data, fdf::CheckLabelFlags &flags, Tlv::Stlv &out);
    //Допилить QString errMsg
    CoreApiConst::ErrorCode b7_1(const Tlv &t2007, quint16 &invalidTag);
    CoreApiConst::ErrorCode b7_2(const Tlv &t1059, quint16 &invalidTag);
    CoreApiConst::ErrorCode b7_3(const Tlv::Stlv &list, quint16 &invalidTag);

    CoreApiConst::ErrorCode readNotification(QByteArray &data);
    CoreApiConst::ErrorCode cancelNotificationReading();
    CoreApiConst::ErrorCode writeNotificationTicket(const QByteArray &data,
                                           quint8 &ofdAnswer, Tlv::Stlv &list);



    CoreApiConst::ErrorCode findDocument(qint32 docNumber, PFsArchiveReportBase &doc, const QStringList &header);
    CoreApiConst::ErrorCode findLastDocument(fdf::DocType type, qint32 from, const FsFullStatus &status,
                                             PFsArchiveReportBase &doc);
    CoreApiConst::ErrorCode getOfdTicketInfo(qint32 docNumber, PFsArchiveOfdTicket &ticket);
    CoreApiConst::ErrorCode getNotSendedDocsCount(quint16 &cnt);
    CoreApiConst::ErrorCode findRegDoc(quint8 seq, PFsArchiveReportBase &doc, const QStringList &header);

    CoreApiConst::ErrorCode getCycleDates(const FsFullStatus &status, QDateTime &opened, QDateTime &closed);



    CoreApiConst::ErrorCode  d3(bool startSession, OfflineDSessionStatus &status);
    CoreApiConst::ErrorCode  d4(bool startNext, quint16 &len, quint32 &num);
    CoreApiConst::ErrorCode  d5(quint16 offcet, quint16 len, QByteArray &data, quint16 &invalidTag);
    CoreApiConst::ErrorCode  d6_0(quint16 &notConfirmed, quint32 &firstNotComfirmed);
    CoreApiConst::ErrorCode  d6_1(quint32 num, quint16 crc);



    FsOfdResponse ofdCmd(const OfdFsCmd &cmd);

private:
    using FsRwTimeout = fs::FsRwTimeout;
    QPointer<FsApi> api_;
    CoreApiConst::ErrorCode exec(const FsReq &req, FsRep &rep,
                                 const FsRwTimeout &tout);

    CoreApiConst::ErrorCode parsingResultToError(fs::RepParsingRes res);

    CoreApiConst::ErrorCode b7(quint8 mode, QByteArray data, quint16 &invalidTag);
};

#endif // FSWRAPPER_H
