#!/bin/sh

set -euo pipefail

usage() {
    echo "Usage: $0 --new_file <path_to_new_file>"
    exit 1
}

# Проверка аргументов
if [[ $# -ne 2 ]]; then
    usage
fi

if [[ "$1" != "--new_file" ]]; then
    usage
fi

NEW_FILE="$2"
TARGET="/opt/sk1/bin/unitcore"

# Проверка существования нового файла
if [[ ! -f "$NEW_FILE" ]]; then
    echo "Error: New file $NEW_FILE does not exist" >&2
    exit 1
fi

# Проверка прав (скрипт должен запускаться от root)
if [[ $(id -u) -ne 0 ]]; then
    echo "Error: This script must be run as root" >&2
    exit 1
fi

# Проверка что новый файл исполняемый
if [[ ! -x "$NEW_FILE" ]]; then
    echo "Error: New file is not executable" >&2
    exit 1
fi

# Создаем временную копию нового файла в целевой директории
TMP_FILE="${TARGET}.new.$$"
install -m 755 -o root -g root "$NEW_FILE" "$TMP_FILE"

# Атомарная замена файла
mv -f "$TMP_FILE" "$TARGET"

echo "Successfully replaced $TARGET"
sleep 10 
reboot
