/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


/*************************************************************************
 ***
 *** Project Name: ASIX
 ***
 *** Module Name: Mos7840
 ***
 *** File: 16C50.h 
 ***		
 ***
 *** File Revision: 0.9
 ***
 *** Revision Date:  16/05/06 
 ***
 ***
 *** Purpose	  : It contains 16C50 UART register defines
 ***
 *** Change History:
 ***
 ***
 *** LEGEND	  :
 ***
 *** 
 ***
 *************************************************************************/

#if !defined(_16C50_H)
#define	_16C50_H

/************************************************************************
 *
 *			D e f i n e s   /   T y p e d e f s
 *
 ************************************************************************/
	
	/* UART register numbers */


#define THR			0	/* Transmit Holding Register (Write) */
#define RDR			0	/* Receive Holding Register (Read)   */	
#define IER			1	/* Interrupt Enable Register	     */
#define FCR			2	/* Fifo Control Register (Write)     */	
#define ISR			2	/* Interrupt Status Register (Read)  */	
#define LCR			3	/* Line Control Register	     */
#define MCR			4	/* Modem Control Register	     */
#define LSR			5	/* Line Status Register		     */
#define MSR			6	/* Modem Status Register	     */
#define SPR			7	/* ScratchPad Register		     */	
#define DLL			8	/* Bank2[ 0 ] Divisor Latch LSB	     */
#define DLM			9	/* Bank2[ 1 ] Divisor Latch MSB      */ 
#define XON1			12	/* Bank2[ 4 ] Xon-1		     */
#define XON2			13	/* Bank2[ 5 ] Xon-2		     */	
#define XOFF1			14	/* Bank2[ 6 ] Xoff-1                 */
#define XOFF2			15	/* Bank2[ 7 ] Xoff-2                 */

#define	NUM_16654_REGS		16

#define IS_REG_2ND_BANK(x)	((x) >= 8)

	/*************************************
	 * Bit definitions for each register *
	 *************************************/

#define IER_RX			0x01	/* Enable receive interrupt */
#define IER_TX			0x02	/* Enable transmit interrupt */
#define IER_RXS			0x04	/* Enable receive status interrupt */
#define IER_MDM			0x08	/* Enable modem status interrupt */
#define IER_SLEEP		0x10	/* Enable sleep mode */
#define IER_XOFF		0x20	/* Enable s/w flow control (XOFF) interrupt */
#define IER_RTS			0x40	/* Enable RTS interrupt */
#define IER_CTS			0x80	/* Enable CTS interrupt */
#define IER_ENABLE_ALL		0xFF	/* Enable all ints */

#define FCR_FIFO_EN		0x01	/* Enable FIFOs */
#define FCR_RXCLR		0x02	/* Reset Rx FIFO */
#define FCR_TXCLR		0x04	/* Reset Tx FIFO */
#define FCR_DMA_BLK		0x08	/* Enable DMA block mode */
#define FCR_TX_LEVEL_MASK	0x30	/* Mask for Tx FIFO Level */
#define FCR_TX_LEVEL_8		0x00	/* Tx FIFO Level =  8 bytes */
#define FCR_TX_LEVEL_16		0x10	/* Tx FIFO Level = 16 bytes */
#define FCR_TX_LEVEL_32		0x20	/* Tx FIFO Level = 32 bytes */
#define FCR_TX_LEVEL_56		0x30	/* Tx FIFO Level = 56 bytes */
#define FCR_RX_LEVEL_MASK	0xC0	/* Mask for Rx FIFO Level */
#define FCR_RX_LEVEL_8		0x00	/* Rx FIFO Level =  8 bytes */
#define FCR_RX_LEVEL_16		0x40	/* Rx FIFO Level = 16 bytes */
#define FCR_RX_LEVEL_56		0x80	/* Rx FIFO Level = 56 bytes */
#define FCR_RX_LEVEL_60		0xC0	/* Rx FIFO Level = 60 bytes */

#define ISR_INT_MDM_STATUS	0x00	/* Modem status int pending */
#define ISR_INT_NONE		0x01	/* No interrupt pending */
#define ISR_INT_TXRDY		0x02	/* Tx ready int pending */
#define ISR_INT_RXRDY		0x04	/* Rx ready int pending */
#define ISR_INT_LINE_STATUS	0x06	/* Line status int pending */
#define ISR_INT_RX_TIMEOUT	0x0C	/* Rx timeout int pending */
#define ISR_INT_RX_XOFF		0x10	/* Rx Xoff int pending */
#define ISR_INT_RTS_CTS		0x20	/* RTS/CTS change int pending */
#define ISR_FIFO_ENABLED	0xC0	/* Bits set if FIFOs enabled */
#define ISR_INT_BITS_MASK	0x3E	/* Mask to isolate valid int causes */

#define LCR_BITS_5		0x00	/* 5 bits/char */
#define LCR_BITS_6		0x01	/* 6 bits/char */
#define LCR_BITS_7		0x02	/* 7 bits/char */
#define LCR_BITS_8		0x03	/* 8 bits/char */
#define LCR_BITS_MASK		0x03	/* Mask for bits/char field */

#define LCR_STOP_1		0x00	/* 1 stop bit */
#define LCR_STOP_1_5		0x04	/* 1.5 stop bits (if 5   bits/char) */
#define LCR_STOP_2		0x04	/* 2 stop bits   (if 6-8 bits/char) */
#define LCR_STOP_MASK		0x04	/* Mask for stop bits field */

#define LCR_PAR_NONE		0x00	/* No parity */
#define LCR_PAR_ODD		0x08	/* Odd parity */
#define LCR_PAR_EVEN		0x18	/* Even parity */
#define LCR_PAR_MARK		0x28	/* Force parity bit to 1 */
#define LCR_PAR_SPACE		0x38	/* Force parity bit to 0 */
#define LCR_PAR_MASK		0x38	/* Mask for parity field */

#define LCR_SET_BREAK		0x40	/* Set Break condition */
#define LCR_DL_ENABLE		0x80	/* Enable access to divisor latch */

#define MCR_DTR			0x01	/* Assert DTR */
#define MCR_RTS			0x02	/* Assert RTS */
#define MCR_OUT1		0x04	/* Loopback only: Sets state of RI */
#define MCR_MASTER_IE		0x08	/* Enable interrupt outputs */
#define MCR_LOOPBACK		0x10	/* Set internal (digital) loopback mode */ 
#define MCR_XON_ANY		0x20	/* Enable any char to exit XOFF mode */
#define MCR_IR_ENABLE		0x40	/* Enable IrDA functions */
#define MCR_BRG_DIV_4		0x80	/* Div baud rate clk by /4 instead of /1 */

#define LSR_RX_AVAIL		0x01	/* Rx data available */
#define LSR_OVER_ERR		0x02	/* Rx overrun */
#define LSR_PAR_ERR		0x04	/* Rx parity error */
#define LSR_FRM_ERR		0x08	/* Rx framing error */
#define LSR_BREAK		0x10	/* Rx break condition detected */
#define LSR_TX_EMPTY		0x20	/* Tx Fifo empty */
#define LSR_TX_ALL_EMPTY	0x40	/* Tx Fifo and shift register empty */
#define LSR_FIFO_ERR		0x80	/* Rx Fifo contains at least 1 errd char */

#define MOS7840_MSR_DELTA_CTS		0x01	/* CTS changed from last read */
#define MOS7840_MSR_DELTA_DSR		0x02	/* DSR changed from last read */
#define MOS7840_MSR_DELTA_RI		0x04	/* RI  changed from 0 -> 1 */
#define MOS7840_MSR_DELTA_CD		0x08	/* CD  changed from last read */
#define MOS7840_MSR_CTS			0x10	/* Current state of CTS */
#define MOS7840_MSR_DSR			0x20	/* Current state of DSR */
#define MOS7840_MSR_RI			0x40	/* Current state of RI */
#define MOS7840_MSR_CD			0x80	/* Current state of CD */

#endif	/* if !defined(_16C50_H) */

